#ifndef KERNEL_LIST
#define KERNEL_LIST

#include "histogram_acf.h"
#include "reduction_acf.h"

KERNEL_INFO kernelInfoConcat(HISTOGRAM_K)(
  "apu_histogram",
  2,
  __port(__index(0),
    __identifier(HISTOGRAM_KN_IN),
    __attributes(ACF_ATTR_VEC_IN),
    __spatial_dep(0,0,0,0),
    __e0_data_type(d08u),
    __e0_size(1, 1),
    __ek_size(1, 1)),
  __port(__index(1),
    __identifier(HISTOGRAM_KN_OUT),
    __attributes(ACF_ATTR_VEC_OUT_STATIC_FIXED),
    __spatial_dep(0,0,0,0),
    __e0_data_type(d32u),
    __e0_size(1, 1),
    __ek_size(256, 1))
);


KERNEL_INFO kernelInfoConcat(REDUCTION_K)(
  "apu_reduction",
  2,
  __port(__index(0),
    __identifier(REDUCTION_KN_IN),
    __attributes(ACF_ATTR_VEC_IN_STATIC_FIXED),
    __spatial_dep(0,0,0,0),
    __e0_data_type(d32u),
    __e0_size(1, 1),
    __ek_size(256, 1)),
  __port(__index(1),
    __identifier(REDUCTION_KN_OUT),
    __attributes(ACF_ATTR_SCL_OUT_STATIC_FIXED),
    __spatial_dep(0,0,0,0),
    __e0_data_type(d32u),
    __e0_size(1, 1),
    __ek_size(256, 1))
);

#endif
